//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include <cpctelera.h>
#include "types.h"
#include "../video/video.h"
#include "../defines.h"
#include "../sprites/sprites.h"
#include "../text/text.h"
#include "../sound/music.h"

#ifndef _ENTITIES_H_
#define _ENTITIES_H_

extern u8 gameOver;
extern u8 pause;
extern u16 score;
extern u8 lives;
extern Keys keys;
extern u8 loopMusic;
extern u8 facingLeft;
extern i8 enemiesToKill;
extern u8 bonus;
extern u8 windows[MAX_WINDOW_ENEMIES];

void addEntity(u8 entityType, i8 xPos, u8 yPos, i8 direction, Entity *enemies, u8 window);
u8 fire(Bullet *bullets, u8 xPos, u8 yPos, u8 dxPos, u8 isLost);


#endif
